/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.client.model.WeaponModels;
import dev.toma.gunsrpg.client.model.weapon.AbstractWeaponModel;
import dev.toma.gunsrpg.client.render.RenderConfigs;
import dev.toma.gunsrpg.client.render.item.AbstractWeaponRenderer;
import dev.toma.gunsrpg.common.init.Skills;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;

public class Hk416Renderer
extends AbstractWeaponRenderer {
    @Override
    public AbstractWeaponModel getWeaponModel() {
        return WeaponModels.HK416;
    }

    @Override
    protected void positionModel(MatrixStack stack, ItemCameraTransforms.TransformType transform) {
        switch (transform) {
            case THIRD_PERSON_RIGHT_HAND: {
                stack.func_227861_a_(-0.2, 0.3, 0.1);
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                stack.func_227861_a_(-0.1, 0.4, 0.0);
            }
        }
    }

    @Override
    protected float scaleForTransform(ItemCameraTransforms.TransformType transform) {
        return transform == ItemCameraTransforms.TransformType.GUI ? 0.27f : 0.2f;
    }

    @Override
    protected void scaleModel(MatrixStack matrixStack, ItemCameraTransforms.TransformType transform) {
        if (!transform.func_241716_a_()) {
            super.scaleModel(matrixStack, transform);
        } else {
            matrixStack.func_227862_a_(0.3f, 0.3f, 0.22f);
        }
    }

    @Override
    protected void transformUI(MatrixStack matrix) {
        matrix.func_227861_a_(0.9, -0.8, 0.0);
    }

    @Override
    protected boolean hasCustomAttachments() {
        return true;
    }

    @Override
    protected void renderAttachments(IPlayerData data, MatrixStack matrix, IRenderTypeBuffer typeBuffer, int light, int overlay, float progress) {
        ISkillProvider provider = data.getSkillProvider();
        if (provider.hasSkill(Skills.HK416_SUPPRESSOR)) {
            Hk416Renderer.renderSuppressor(RenderConfigs.HK416_SUPPRESSOR, matrix, typeBuffer, light, overlay, progress);
        }
        if (provider.hasSkill(Skills.HK416_RED_DOT)) {
            Hk416Renderer.renderReflex(RenderConfigs.HK416_REFLEX, matrix, typeBuffer, light, overlay, progress);
        }
    }
}

